setwd("<your directory or folder path>")

#n <- 25 #sample size
alpha <- 0.05 

#
# 
# delsig is the true relative difference between actual and null mean per unit standard deviation


# Tcrit is the two-sided (+/-) critical value for the t-test statistic:
Tcrit <- qt(p=1-alpha/2,df=n-1,ncp=0.0) #this is the 100(1-alpha/2) percentile of the t distribution with n-1 d.f.
#
# ncp is called the non-centrality parameter; when the null hypothesis of zero difference is true, then ncp = 0.0
# as the truth departs from the null (i.e., as delta differs from 0), the ncp changes
#
n <- seq(from=5, to=45, by=1)
delsig <- 0.75
# power is the probability of rejecting the null hypothesis: H0: mu = mu0, given 
# that the true relative difference is delsig.
# Note that if delsig = 0, the power is equal to alpha
power <- pt(q=Tcrit,df=n-1,ncp=delsig*sqrt(n),lower.tail=FALSE)+pt(q=-Tcrit,df=n-1,ncp=delsig*sqrt(n),lower.tail=TRUE)

plot(n,power,type="b",xaxt="n",ylim=c(0,1))
axis(side=1,at=n)
text(x=10,y=0.92,"power=0.95")
text(x=10,y=0.07,"power=0.05")
text(x=28,y=0.50,"n = 25")
#text(x=1.25,y=0.50,"delsig=+0.75")

abline(h=0.95)
abline(h=alpha)
abline(v=25)
#abline(v=0.75)

df3 <- cbind(n,alpha,delsig, power)

write.csv(df3,"20180114 Sample Size for One Sample T test.csv")